<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/

$page_title = "SS Get Search Engine";
$page_h1 = "Select String Search Engine";
include "ft_ss_need_logs.php";

if (!file_exists($root )){
	header ('Location: ft_ss_no_log.php');
	exit;
}
?>

 <?php
 	$mess = $_GET["mess"];
	if ($mess == "xx"){
		printf ("<p><b>You can't <i>Run A Test Case</i> until you select a search engine</b>\n");
	}
	if ($need_se == 0){
		printf ('<p>Current Search Engine is <b>%s</b></p>',$engine[0]);
 		echo "<p>You can keep testing the current search engine or specify a different ";
		echo " search engine.</p>";
	}
	else {
		printf ('<h2>No Current Search Engine</h2>');
	}
 ?>

 <h2>Specify Search Engine For Testing</h2>
 <form method="POST"
 action="/stringsearch/ft_ss_update.php">
 A search tool may have more than one search engine that can be used. Usually this is
 a choice between a live search (Scans the data set for a match to a target) or an indexed
 search (before doing any searching the data set is scanned and an index is built so that
 a search is just a look up in the index).
 <p>
 You need to select a search engine from the list below:
 <p><input type="radio" name="Engine" value="Live">Live
 <p><input type="radio" checked="checked" name="Engine" value="Indexed">Indexed
 <p><input type="radio" name="Engine" value="Other">Other
 <p>
 If Other is selected, enter the other search engine name: <input name="se_name"
 style="background-color:#AAFFAA" type="text" value=""><br>
 <br>
 </p>
 <br>
 <input type="hidden" name="what" value="Engine">
 <input value="Record Selected Search Engine" type="submit"> </form>

 <br>
<?php
include "ft_ss_tail.php";
?>
